﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using PI.FM.N000.Base.WinForms.Controls;

namespace PI.ZB.N1200.ELearning.WinForms.Instructor
{
    public partial class UCTabInstructorDetails : PI.FM.N000.Base.WinForms.Controls.TabPageContainerControl
    {
        private Gemini.Utility.Collections.AutoDictionary<long?, BL.BO.School> _dictionarySchool = null;

        private PI.FM.N001.Account.BL.Account _blAccount = null;

        protected PI.FM.N001.Account.BL.Account BLAccount
        {
            get
            {
                if (_blAccount == null)
                {
                    _blAccount = new PI.FM.N001.Account.BL.Account(this.Environment);
                }
                return _blAccount;
            }
        }

        protected Gemini.Utility.Collections.AutoDictionary<long?, BL.BO.School> DictionarySchool
        {
            get
            {
                if (_dictionarySchool == null)
                {
                    _dictionarySchool = new Gemini.Utility.Collections.AutoDictionary<long?, BL.BO.School>(UCDetails.BLZSBELearning.School.Restore);
                }

                return _dictionarySchool;
            }
        }

        public UCTabInstructorDetails()
        {
            InitializeComponent();
            Dock = DockStyle.Fill;
        }

        protected UCInstructorDetails UCDetails
        {
            get { return (UCInstructorDetails)base.UCBODetails; }
        }

        protected override void OnInitialize()
        {
            base.OnInitialize();

            UCDetails.DataManager.Bindings.Add(_gTextBoxSurename, "Surename", _gLabelSurename);
            UCDetails.DataManager.Bindings.Add(_gTextBoxForename, "Forename", _gLabelForename);
            UCDetails.DataManager.Bindings.Add(_gTextBoxTelefon, "Tel", _gLabelTelefon);
            UCDetails.DataManager.Bindings.Add(_gTextBoxEmail, "Email", _gLabelEmail);
        }

        public override void DoRestore()
        {
                _gTextBoxSchool.Text = GetSchoolName();
        }

        public override bool DoSave()
        {
            if (UCDetails.DataManager.Current != null)
            {
                PI.FM.N001.Account.BL.BO.User _User = BLAccount.User.RestoreByID(UCDetails.DataManager.Current.UserID);

                if (_User != null)
                {
                    _User.Surname = UCDetails.DataManager.Current.Surename;
                    _User.Name = UCDetails.DataManager.Current.Forename;
                    _User.Email = UCDetails.DataManager.Current.Email;

                    return BLAccount.User.Save(_User).Success;
                }
            }
            return true;
        }

        private string GetSchoolName()
        {
            string _schoolName = string.Empty;

            if ((UCDetails.DataManager.Current != null) && (UCDetails.DataManager.Current.SchoolID.HasValue))
            {
                if (DictionarySchool.Restore(UCDetails.DataManager.Current.SchoolID.Value) != null)
                {
                    _schoolName = DictionarySchool.Restore(UCDetails.DataManager.Current.SchoolID.Value).Name;
                }
            }

            return _schoolName;
        }
    }
}
